import { configureStore } from "@reduxjs/toolkit";
import { logout } from "../slices/auth/signIn";
import rootReducer from "./rootReducer";

const check = (store) => (next) => async (action) => {
    const response = action?.payload;
    const { status: { code, message } = {} } = response || {};
    if (code == 401 && message == "Unauthorized") {
        store.dispatch(logout());
    }

    return next(action);
};

const store = configureStore({
    reducer: rootReducer,
    middleware: (getDefaultMiddleware) =>
        getDefaultMiddleware({
            immutableCheck: false,
            serializableCheck: false,
        }).concat(check),
    devTools: process.env.NODE_ENV !== "production",
});
export default store;
